/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_COIL_COOLING_DX_FIELDENUMS_HXX
#define UTILITIES_IDD_COIL_COOLING_DX_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class Coil_Cooling_DXFields
 *  \brief Enumeration of Coil:Cooling:DX's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(Coil_Cooling_DXFields, )
#else
class Coil_Cooling_DXFields: public ::EnumBase<Coil_Cooling_DXFields> {
 public: 
  enum domain 
  {
Name, EvaporatorInletNodeName, EvaporatorOutletNodeName, AvailabilityScheduleName, CondenserZoneName, CondenserInletNodeName, CondenserOutletNodeName, PerformanceObjectName, CondensateCollectionWaterStorageTankName, EvaporativeCondenserSupplyWaterStorageTankName,   };
  Coil_Cooling_DXFields()
   : EnumBase<Coil_Cooling_DXFields>(Name) {} 
  Coil_Cooling_DXFields(const std::string &t_name) 
   : EnumBase<Coil_Cooling_DXFields>(t_name) {} 
  Coil_Cooling_DXFields(int t_value) 
   : EnumBase<Coil_Cooling_DXFields>(t_value) {} 
  static std::string enumName() 
  { return "Coil_Cooling_DXFields"; }
  domain value() const { return static_cast<domain>(EnumBase<Coil_Cooling_DXFields>::integer_value()); }
   private:
    friend class EnumBase<Coil_Cooling_DXFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ Coil_Cooling_DXFields::Name, "Name", "Name"},
{ Coil_Cooling_DXFields::EvaporatorInletNodeName, "EvaporatorInletNodeName", "Evaporator Inlet Node Name"},
{ Coil_Cooling_DXFields::EvaporatorOutletNodeName, "EvaporatorOutletNodeName", "Evaporator Outlet Node Name"},
{ Coil_Cooling_DXFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ Coil_Cooling_DXFields::CondenserZoneName, "CondenserZoneName", "Condenser Zone Name"},
{ Coil_Cooling_DXFields::CondenserInletNodeName, "CondenserInletNodeName", "Condenser Inlet Node Name"},
{ Coil_Cooling_DXFields::CondenserOutletNodeName, "CondenserOutletNodeName", "Condenser Outlet Node Name"},
{ Coil_Cooling_DXFields::PerformanceObjectName, "PerformanceObjectName", "Performance Object Name"},
{ Coil_Cooling_DXFields::CondensateCollectionWaterStorageTankName, "CondensateCollectionWaterStorageTankName", "Condensate Collection Water Storage Tank Name"},
{ Coil_Cooling_DXFields::EvaporativeCondenserSupplyWaterStorageTankName, "EvaporativeCondenserSupplyWaterStorageTankName", "Evaporative Condenser Supply Water Storage Tank Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const Coil_Cooling_DXFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<Coil_Cooling_DXFields> OptionalCoil_Cooling_DXFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_COIL_COOLING_DX_FIELDENUMS_HXX
