/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_AIRTERMINAL_SINGLEDUCT_SERIESPIU_REHEAT_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_AIRTERMINAL_SINGLEDUCT_SERIESPIU_REHEAT_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields
 *  \brief Enumeration of OS:AirTerminal:SingleDuct:SeriesPIU:Reheat's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields, )
#else
class OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields: public ::EnumBase<OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields> {
 public: 
  enum domain 
  {
Handle, Name, AvailabilityScheduleName, MaximumAirFlowRate, MaximumPrimaryAirFlowRate, MinimumPrimaryAirFlowFraction, SupplyAirInletNode, SecondaryAirInletNode, OutletNode, ReheatCoilAirInletNode, ZoneMixerName, FanName, ReheatCoilName, MaximumHotWaterorSteamFlowRate, MinimumHotWaterorSteamFlowRate, ConvergenceTolerance, FanControlType, MinimumFanTurnDownRatio, HeatingControlType, DesignHeatingDischargeAirTemperature, HighLimitHeatingDischargeAirTemperature,   };
  OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields()
   : EnumBase<OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields>(Handle) {} 
  OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields(const std::string &t_name) 
   : EnumBase<OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields>(t_name) {} 
  OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields(int t_value) 
   : EnumBase<OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields>::integer_value()); }
   private:
    friend class EnumBase<OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::Handle, "Handle", "Handle"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::Name, "Name", "Name"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::MaximumAirFlowRate, "MaximumAirFlowRate", "Maximum Air Flow Rate"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::MaximumPrimaryAirFlowRate, "MaximumPrimaryAirFlowRate", "Maximum Primary Air Flow Rate"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::MinimumPrimaryAirFlowFraction, "MinimumPrimaryAirFlowFraction", "Minimum Primary Air Flow Fraction"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::SupplyAirInletNode, "SupplyAirInletNode", "Supply Air Inlet Node"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::SecondaryAirInletNode, "SecondaryAirInletNode", "Secondary Air Inlet Node"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::OutletNode, "OutletNode", "Outlet Node"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::ReheatCoilAirInletNode, "ReheatCoilAirInletNode", "Reheat Coil Air Inlet Node"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::ZoneMixerName, "ZoneMixerName", "Zone Mixer Name"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::FanName, "FanName", "Fan Name"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::ReheatCoilName, "ReheatCoilName", "Reheat Coil Name"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::MaximumHotWaterorSteamFlowRate, "MaximumHotWaterorSteamFlowRate", "Maximum Hot Water or Steam Flow Rate"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::MinimumHotWaterorSteamFlowRate, "MinimumHotWaterorSteamFlowRate", "Minimum Hot Water or Steam Flow Rate"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::ConvergenceTolerance, "ConvergenceTolerance", "Convergence Tolerance"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::FanControlType, "FanControlType", "Fan Control Type"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::MinimumFanTurnDownRatio, "MinimumFanTurnDownRatio", "Minimum Fan Turn Down Ratio"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::HeatingControlType, "HeatingControlType", "Heating Control Type"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::DesignHeatingDischargeAirTemperature, "DesignHeatingDischargeAirTemperature", "Design Heating Discharge Air Temperature"},
{ OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields::HighLimitHeatingDischargeAirTemperature, "HighLimitHeatingDischargeAirTemperature", "High Limit Heating Discharge Air Temperature"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields> OptionalOS_AirTerminal_SingleDuct_SeriesPIU_ReheatFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_AIRTERMINAL_SINGLEDUCT_SERIESPIU_REHEAT_FIELDENUMS_HXX
