/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_SHADOWCALCULATION_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_SHADOWCALCULATION_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_ShadowCalculationFields
 *  \brief Enumeration of OS:ShadowCalculation's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_ShadowCalculationFields, )
#else
class OS_ShadowCalculationFields: public ::EnumBase<OS_ShadowCalculationFields> {
 public: 
  enum domain 
  {
Handle, ShadingCalculationMethod, ShadingCalculationUpdateFrequencyMethod, ShadingCalculationUpdateFrequency, MaximumFiguresinShadowOverlapCalculations, PolygonClippingAlgorithm, PixelCountingResolution, SkyDiffuseModelingAlgorithm, OutputExternalShadingCalculationResults, DisableSelfShadingWithinShadingZoneGroups, DisableSelfShadingFromShadingZoneGroupstoOtherZones,   };
  OS_ShadowCalculationFields()
   : EnumBase<OS_ShadowCalculationFields>(Handle) {} 
  OS_ShadowCalculationFields(const std::string &t_name) 
   : EnumBase<OS_ShadowCalculationFields>(t_name) {} 
  OS_ShadowCalculationFields(int t_value) 
   : EnumBase<OS_ShadowCalculationFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_ShadowCalculationFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_ShadowCalculationFields>::integer_value()); }
   private:
    friend class EnumBase<OS_ShadowCalculationFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_ShadowCalculationFields::Handle, "Handle", "Handle"},
{ OS_ShadowCalculationFields::ShadingCalculationMethod, "ShadingCalculationMethod", "Shading Calculation Method"},
{ OS_ShadowCalculationFields::ShadingCalculationUpdateFrequencyMethod, "ShadingCalculationUpdateFrequencyMethod", "Shading Calculation Update Frequency Method"},
{ OS_ShadowCalculationFields::ShadingCalculationUpdateFrequency, "ShadingCalculationUpdateFrequency", "Shading Calculation Update Frequency"},
{ OS_ShadowCalculationFields::MaximumFiguresinShadowOverlapCalculations, "MaximumFiguresinShadowOverlapCalculations", "Maximum Figures in Shadow Overlap Calculations"},
{ OS_ShadowCalculationFields::PolygonClippingAlgorithm, "PolygonClippingAlgorithm", "Polygon Clipping Algorithm"},
{ OS_ShadowCalculationFields::PixelCountingResolution, "PixelCountingResolution", "Pixel Counting Resolution"},
{ OS_ShadowCalculationFields::SkyDiffuseModelingAlgorithm, "SkyDiffuseModelingAlgorithm", "Sky Diffuse Modeling Algorithm"},
{ OS_ShadowCalculationFields::OutputExternalShadingCalculationResults, "OutputExternalShadingCalculationResults", "Output External Shading Calculation Results"},
{ OS_ShadowCalculationFields::DisableSelfShadingWithinShadingZoneGroups, "DisableSelfShadingWithinShadingZoneGroups", "Disable Self-Shading Within Shading Zone Groups"},
{ OS_ShadowCalculationFields::DisableSelfShadingFromShadingZoneGroupstoOtherZones, "DisableSelfShadingFromShadingZoneGroupstoOtherZones", "Disable Self-Shading From Shading Zone Groups to Other Zones"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_ShadowCalculationFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_ShadowCalculationFields> OptionalOS_ShadowCalculationFields ;
#endif

/** \class OS_ShadowCalculationExtensibleFields
 *  \brief Enumeration of OS:ShadowCalculation's Idd and Idf extensible fields
 *  to be used in conjunction with ExtensibleIndex and ExtensibleGroup.
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer ExtensibleIndex.field indices. (The enumeration value names
 *  are more likely to be valid across EnergyPlus and OpenStudio releases, and will break
 *  if they become invalid.)See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_ShadowCalculationExtensibleFields, )
#else
class OS_ShadowCalculationExtensibleFields: public ::EnumBase<OS_ShadowCalculationExtensibleFields> {
 public: 
  enum domain 
  {
ShadingZoneGroup,   };
  OS_ShadowCalculationExtensibleFields()
   : EnumBase<OS_ShadowCalculationExtensibleFields>(ShadingZoneGroup) {} 
  OS_ShadowCalculationExtensibleFields(const std::string &t_name) 
   : EnumBase<OS_ShadowCalculationExtensibleFields>(t_name) {} 
  OS_ShadowCalculationExtensibleFields(int t_value) 
   : EnumBase<OS_ShadowCalculationExtensibleFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_ShadowCalculationExtensibleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_ShadowCalculationExtensibleFields>::integer_value()); }
   private:
    friend class EnumBase<OS_ShadowCalculationExtensibleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_ShadowCalculationExtensibleFields::ShadingZoneGroup, "ShadingZoneGroup", "Shading Zone Group"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_ShadowCalculationExtensibleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_ShadowCalculationExtensibleFields> OptionalOS_ShadowCalculationExtensibleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_SHADOWCALCULATION_FIELDENUMS_HXX
