/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_ENERGYMANAGEMENTSYSTEM_SUBROUTINE_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_ENERGYMANAGEMENTSYSTEM_SUBROUTINE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_EnergyManagementSystem_SubroutineFields
 *  \brief Enumeration of OS:EnergyManagementSystem:Subroutine's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_EnergyManagementSystem_SubroutineFields, )
#else
class OS_EnergyManagementSystem_SubroutineFields: public ::EnumBase<OS_EnergyManagementSystem_SubroutineFields> {
 public: 
  enum domain 
  {
Handle, Name,   };
  OS_EnergyManagementSystem_SubroutineFields()
   : EnumBase<OS_EnergyManagementSystem_SubroutineFields>(Handle) {} 
  OS_EnergyManagementSystem_SubroutineFields(const std::string &t_name) 
   : EnumBase<OS_EnergyManagementSystem_SubroutineFields>(t_name) {} 
  OS_EnergyManagementSystem_SubroutineFields(int t_value) 
   : EnumBase<OS_EnergyManagementSystem_SubroutineFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_EnergyManagementSystem_SubroutineFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_EnergyManagementSystem_SubroutineFields>::integer_value()); }
   private:
    friend class EnumBase<OS_EnergyManagementSystem_SubroutineFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_EnergyManagementSystem_SubroutineFields::Handle, "Handle", "Handle"},
{ OS_EnergyManagementSystem_SubroutineFields::Name, "Name", "Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_EnergyManagementSystem_SubroutineFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_EnergyManagementSystem_SubroutineFields> OptionalOS_EnergyManagementSystem_SubroutineFields ;
#endif

/** \class OS_EnergyManagementSystem_SubroutineExtensibleFields
 *  \brief Enumeration of OS:EnergyManagementSystem:Subroutine's Idd and Idf extensible fields
 *  to be used in conjunction with ExtensibleIndex and ExtensibleGroup.
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer ExtensibleIndex.field indices. (The enumeration value names
 *  are more likely to be valid across EnergyPlus and OpenStudio releases, and will break
 *  if they become invalid.)See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_EnergyManagementSystem_SubroutineExtensibleFields, )
#else
class OS_EnergyManagementSystem_SubroutineExtensibleFields: public ::EnumBase<OS_EnergyManagementSystem_SubroutineExtensibleFields> {
 public: 
  enum domain 
  {
ProgramLine,   };
  OS_EnergyManagementSystem_SubroutineExtensibleFields()
   : EnumBase<OS_EnergyManagementSystem_SubroutineExtensibleFields>(ProgramLine) {} 
  OS_EnergyManagementSystem_SubroutineExtensibleFields(const std::string &t_name) 
   : EnumBase<OS_EnergyManagementSystem_SubroutineExtensibleFields>(t_name) {} 
  OS_EnergyManagementSystem_SubroutineExtensibleFields(int t_value) 
   : EnumBase<OS_EnergyManagementSystem_SubroutineExtensibleFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_EnergyManagementSystem_SubroutineExtensibleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_EnergyManagementSystem_SubroutineExtensibleFields>::integer_value()); }
   private:
    friend class EnumBase<OS_EnergyManagementSystem_SubroutineExtensibleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_EnergyManagementSystem_SubroutineExtensibleFields::ProgramLine, "ProgramLine", "Program Line"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_EnergyManagementSystem_SubroutineExtensibleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_EnergyManagementSystem_SubroutineExtensibleFields> OptionalOS_EnergyManagementSystem_SubroutineExtensibleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_ENERGYMANAGEMENTSYSTEM_SUBROUTINE_FIELDENUMS_HXX
