/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_THERMOSTATSETPOINT_DUALSETPOINT_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_THERMOSTATSETPOINT_DUALSETPOINT_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_ThermostatSetpoint_DualSetpointFields
 *  \brief Enumeration of OS:ThermostatSetpoint:DualSetpoint's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_ThermostatSetpoint_DualSetpointFields, )
#else
class OS_ThermostatSetpoint_DualSetpointFields: public ::EnumBase<OS_ThermostatSetpoint_DualSetpointFields> {
 public: 
  enum domain 
  {
Handle, Name, HeatingSetpointTemperatureScheduleName, CoolingSetpointTemperatureScheduleName, TemperatureDifferenceBetweenCutoutAndSetpoint,   };
  OS_ThermostatSetpoint_DualSetpointFields()
   : EnumBase<OS_ThermostatSetpoint_DualSetpointFields>(Handle) {} 
  OS_ThermostatSetpoint_DualSetpointFields(const std::string &t_name) 
   : EnumBase<OS_ThermostatSetpoint_DualSetpointFields>(t_name) {} 
  OS_ThermostatSetpoint_DualSetpointFields(int t_value) 
   : EnumBase<OS_ThermostatSetpoint_DualSetpointFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_ThermostatSetpoint_DualSetpointFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_ThermostatSetpoint_DualSetpointFields>::integer_value()); }
   private:
    friend class EnumBase<OS_ThermostatSetpoint_DualSetpointFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_ThermostatSetpoint_DualSetpointFields::Handle, "Handle", "Handle"},
{ OS_ThermostatSetpoint_DualSetpointFields::Name, "Name", "Name"},
{ OS_ThermostatSetpoint_DualSetpointFields::HeatingSetpointTemperatureScheduleName, "HeatingSetpointTemperatureScheduleName", "Heating Setpoint Temperature Schedule Name"},
{ OS_ThermostatSetpoint_DualSetpointFields::CoolingSetpointTemperatureScheduleName, "CoolingSetpointTemperatureScheduleName", "Cooling Setpoint Temperature Schedule Name"},
{ OS_ThermostatSetpoint_DualSetpointFields::TemperatureDifferenceBetweenCutoutAndSetpoint, "TemperatureDifferenceBetweenCutoutAndSetpoint", "Temperature Difference Between Cutout And Setpoint"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_ThermostatSetpoint_DualSetpointFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_ThermostatSetpoint_DualSetpointFields> OptionalOS_ThermostatSetpoint_DualSetpointFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_THERMOSTATSETPOINT_DUALSETPOINT_FIELDENUMS_HXX
