/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_CONSTRUCTION_FIELDENUMS_HXX
#define UTILITIES_IDD_CONSTRUCTION_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class ConstructionFields
 *  \brief Enumeration of Construction's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ConstructionFields, )
#else
class ConstructionFields: public ::EnumBase<ConstructionFields> {
 public: 
  enum domain 
  {
Name,   };
  ConstructionFields()
   : EnumBase<ConstructionFields>(Name) {} 
  ConstructionFields(const std::string &t_name) 
   : EnumBase<ConstructionFields>(t_name) {} 
  ConstructionFields(int t_value) 
   : EnumBase<ConstructionFields>(t_value) {} 
  static std::string enumName() 
  { return "ConstructionFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ConstructionFields>::integer_value()); }
   private:
    friend class EnumBase<ConstructionFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ConstructionFields::Name, "Name", "Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ConstructionFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ConstructionFields> OptionalConstructionFields ;
#endif

/** \class ConstructionExtensibleFields
 *  \brief Enumeration of Construction's Idd and Idf extensible fields
 *  to be used in conjunction with ExtensibleIndex and ExtensibleGroup.
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer ExtensibleIndex.field indices. (The enumeration value names
 *  are more likely to be valid across EnergyPlus and OpenStudio releases, and will break
 *  if they become invalid.)See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(ConstructionExtensibleFields, )
#else
class ConstructionExtensibleFields: public ::EnumBase<ConstructionExtensibleFields> {
 public: 
  enum domain 
  {
Layer,   };
  ConstructionExtensibleFields()
   : EnumBase<ConstructionExtensibleFields>(Layer) {} 
  ConstructionExtensibleFields(const std::string &t_name) 
   : EnumBase<ConstructionExtensibleFields>(t_name) {} 
  ConstructionExtensibleFields(int t_value) 
   : EnumBase<ConstructionExtensibleFields>(t_value) {} 
  static std::string enumName() 
  { return "ConstructionExtensibleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<ConstructionExtensibleFields>::integer_value()); }
   private:
    friend class EnumBase<ConstructionExtensibleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ ConstructionExtensibleFields::Layer, "Layer", "Layer"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const ConstructionExtensibleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<ConstructionExtensibleFields> OptionalConstructionExtensibleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_CONSTRUCTION_FIELDENUMS_HXX
