/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_AIRFLOWNETWORK_OCCUPANTVENTILATIONCONTROL_FIELDENUMS_HXX
#define UTILITIES_IDD_AIRFLOWNETWORK_OCCUPANTVENTILATIONCONTROL_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class AirflowNetwork_OccupantVentilationControlFields
 *  \brief Enumeration of AirflowNetwork:OccupantVentilationControl's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(AirflowNetwork_OccupantVentilationControlFields, )
#else
class AirflowNetwork_OccupantVentilationControlFields: public ::EnumBase<AirflowNetwork_OccupantVentilationControlFields> {
 public: 
  enum domain 
  {
Name, MinimumOpeningTime, MinimumClosingTime, ThermalComfortLowTemperatureCurveName, ThermalComfortTemperatureBoundaryPoint, ThermalComfortHighTemperatureCurveName, MaximumThresholdforPersonsDissatisfiedPPD, OccupancyCheck, OpeningProbabilityScheduleName, ClosingProbabilityScheduleName,   };
  AirflowNetwork_OccupantVentilationControlFields()
   : EnumBase<AirflowNetwork_OccupantVentilationControlFields>(Name) {} 
  AirflowNetwork_OccupantVentilationControlFields(const std::string &t_name) 
   : EnumBase<AirflowNetwork_OccupantVentilationControlFields>(t_name) {} 
  AirflowNetwork_OccupantVentilationControlFields(int t_value) 
   : EnumBase<AirflowNetwork_OccupantVentilationControlFields>(t_value) {} 
  static std::string enumName() 
  { return "AirflowNetwork_OccupantVentilationControlFields"; }
  domain value() const { return static_cast<domain>(EnumBase<AirflowNetwork_OccupantVentilationControlFields>::integer_value()); }
   private:
    friend class EnumBase<AirflowNetwork_OccupantVentilationControlFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ AirflowNetwork_OccupantVentilationControlFields::Name, "Name", "Name"},
{ AirflowNetwork_OccupantVentilationControlFields::MinimumOpeningTime, "MinimumOpeningTime", "Minimum Opening Time"},
{ AirflowNetwork_OccupantVentilationControlFields::MinimumClosingTime, "MinimumClosingTime", "Minimum Closing Time"},
{ AirflowNetwork_OccupantVentilationControlFields::ThermalComfortLowTemperatureCurveName, "ThermalComfortLowTemperatureCurveName", "Thermal Comfort Low Temperature Curve Name"},
{ AirflowNetwork_OccupantVentilationControlFields::ThermalComfortTemperatureBoundaryPoint, "ThermalComfortTemperatureBoundaryPoint", "Thermal Comfort Temperature Boundary Point"},
{ AirflowNetwork_OccupantVentilationControlFields::ThermalComfortHighTemperatureCurveName, "ThermalComfortHighTemperatureCurveName", "Thermal Comfort High Temperature Curve Name"},
{ AirflowNetwork_OccupantVentilationControlFields::MaximumThresholdforPersonsDissatisfiedPPD, "MaximumThresholdforPersonsDissatisfiedPPD", "Maximum Threshold for Persons Dissatisfied PPD"},
{ AirflowNetwork_OccupantVentilationControlFields::OccupancyCheck, "OccupancyCheck", "Occupancy Check"},
{ AirflowNetwork_OccupantVentilationControlFields::OpeningProbabilityScheduleName, "OpeningProbabilityScheduleName", "Opening Probability Schedule Name"},
{ AirflowNetwork_OccupantVentilationControlFields::ClosingProbabilityScheduleName, "ClosingProbabilityScheduleName", "Closing Probability Schedule Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const AirflowNetwork_OccupantVentilationControlFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<AirflowNetwork_OccupantVentilationControlFields> OptionalAirflowNetwork_OccupantVentilationControlFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_AIRFLOWNETWORK_OCCUPANTVENTILATIONCONTROL_FIELDENUMS_HXX
