/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_BUILDING_FIELDENUMS_HXX
#define UTILITIES_IDD_BUILDING_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class BuildingFields
 *  \brief Enumeration of Building's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(BuildingFields, )
#else
class BuildingFields: public ::EnumBase<BuildingFields> {
 public: 
  enum domain 
  {
Name, NorthAxis, Terrain, LoadsConvergenceToleranceValue, TemperatureConvergenceToleranceValue, SolarDistribution, MaximumNumberofWarmupDays, MinimumNumberofWarmupDays,   };
  BuildingFields()
   : EnumBase<BuildingFields>(Name) {} 
  BuildingFields(const std::string &t_name) 
   : EnumBase<BuildingFields>(t_name) {} 
  BuildingFields(int t_value) 
   : EnumBase<BuildingFields>(t_value) {} 
  static std::string enumName() 
  { return "BuildingFields"; }
  domain value() const { return static_cast<domain>(EnumBase<BuildingFields>::integer_value()); }
   private:
    friend class EnumBase<BuildingFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ BuildingFields::Name, "Name", "Name"},
{ BuildingFields::NorthAxis, "NorthAxis", "North Axis"},
{ BuildingFields::Terrain, "Terrain", "Terrain"},
{ BuildingFields::LoadsConvergenceToleranceValue, "LoadsConvergenceToleranceValue", "Loads Convergence Tolerance Value"},
{ BuildingFields::TemperatureConvergenceToleranceValue, "TemperatureConvergenceToleranceValue", "Temperature Convergence Tolerance Value"},
{ BuildingFields::SolarDistribution, "SolarDistribution", "Solar Distribution"},
{ BuildingFields::MaximumNumberofWarmupDays, "MaximumNumberofWarmupDays", "Maximum Number of Warmup Days"},
{ BuildingFields::MinimumNumberofWarmupDays, "MinimumNumberofWarmupDays", "Minimum Number of Warmup Days"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const BuildingFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<BuildingFields> OptionalBuildingFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_BUILDING_FIELDENUMS_HXX
