/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_AIRTERMINAL_DUALDUCT_VAV_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_AIRTERMINAL_DUALDUCT_VAV_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_AirTerminal_DualDuct_VAVFields
 *  \brief Enumeration of OS:AirTerminal:DualDuct:VAV's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_AirTerminal_DualDuct_VAVFields, )
#else
class OS_AirTerminal_DualDuct_VAVFields: public ::EnumBase<OS_AirTerminal_DualDuct_VAVFields> {
 public: 
  enum domain 
  {
Handle, Name, AvailabilitySchedule, AirOutletNode, HotAirInletNode, ColdAirInletNode, MaximumDamperAirFlowRate, ZoneMinimumAirFlowFraction, DesignSpecificationOutdoorAirObject, MinimumAirFlowTurndownScheduleName,   };
  OS_AirTerminal_DualDuct_VAVFields()
   : EnumBase<OS_AirTerminal_DualDuct_VAVFields>(Handle) {} 
  OS_AirTerminal_DualDuct_VAVFields(const std::string &t_name) 
   : EnumBase<OS_AirTerminal_DualDuct_VAVFields>(t_name) {} 
  OS_AirTerminal_DualDuct_VAVFields(int t_value) 
   : EnumBase<OS_AirTerminal_DualDuct_VAVFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_AirTerminal_DualDuct_VAVFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_AirTerminal_DualDuct_VAVFields>::integer_value()); }
   private:
    friend class EnumBase<OS_AirTerminal_DualDuct_VAVFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_AirTerminal_DualDuct_VAVFields::Handle, "Handle", "Handle"},
{ OS_AirTerminal_DualDuct_VAVFields::Name, "Name", "Name"},
{ OS_AirTerminal_DualDuct_VAVFields::AvailabilitySchedule, "AvailabilitySchedule", "Availability Schedule"},
{ OS_AirTerminal_DualDuct_VAVFields::AirOutletNode, "AirOutletNode", "Air Outlet Node"},
{ OS_AirTerminal_DualDuct_VAVFields::HotAirInletNode, "HotAirInletNode", "Hot Air Inlet Node"},
{ OS_AirTerminal_DualDuct_VAVFields::ColdAirInletNode, "ColdAirInletNode", "Cold Air Inlet Node"},
{ OS_AirTerminal_DualDuct_VAVFields::MaximumDamperAirFlowRate, "MaximumDamperAirFlowRate", "Maximum Damper Air Flow Rate"},
{ OS_AirTerminal_DualDuct_VAVFields::ZoneMinimumAirFlowFraction, "ZoneMinimumAirFlowFraction", "Zone Minimum Air Flow Fraction"},
{ OS_AirTerminal_DualDuct_VAVFields::DesignSpecificationOutdoorAirObject, "DesignSpecificationOutdoorAirObject", "Design Specification Outdoor Air Object"},
{ OS_AirTerminal_DualDuct_VAVFields::MinimumAirFlowTurndownScheduleName, "MinimumAirFlowTurndownScheduleName", "Minimum Air Flow Turndown Schedule Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_AirTerminal_DualDuct_VAVFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_AirTerminal_DualDuct_VAVFields> OptionalOS_AirTerminal_DualDuct_VAVFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_AIRTERMINAL_DUALDUCT_VAV_FIELDENUMS_HXX
