/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_MATERIALPROPERTY_HEATANDMOISTURETRANSFER_SUCTION_FIELDENUMS_HXX
#define UTILITIES_IDD_MATERIALPROPERTY_HEATANDMOISTURETRANSFER_SUCTION_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class MaterialProperty_HeatAndMoistureTransfer_SuctionFields
 *  \brief Enumeration of MaterialProperty:HeatAndMoistureTransfer:Suction's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(MaterialProperty_HeatAndMoistureTransfer_SuctionFields, )
#else
class MaterialProperty_HeatAndMoistureTransfer_SuctionFields: public ::EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionFields> {
 public: 
  enum domain 
  {
MaterialName, NumberofSuctionpoints,   };
  MaterialProperty_HeatAndMoistureTransfer_SuctionFields()
   : EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionFields>(MaterialName) {} 
  MaterialProperty_HeatAndMoistureTransfer_SuctionFields(const std::string &t_name) 
   : EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionFields>(t_name) {} 
  MaterialProperty_HeatAndMoistureTransfer_SuctionFields(int t_value) 
   : EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionFields>(t_value) {} 
  static std::string enumName() 
  { return "MaterialProperty_HeatAndMoistureTransfer_SuctionFields"; }
  domain value() const { return static_cast<domain>(EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionFields>::integer_value()); }
   private:
    friend class EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ MaterialProperty_HeatAndMoistureTransfer_SuctionFields::MaterialName, "MaterialName", "Material Name"},
{ MaterialProperty_HeatAndMoistureTransfer_SuctionFields::NumberofSuctionpoints, "NumberofSuctionpoints", "Number of Suction points"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const MaterialProperty_HeatAndMoistureTransfer_SuctionFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<MaterialProperty_HeatAndMoistureTransfer_SuctionFields> OptionalMaterialProperty_HeatAndMoistureTransfer_SuctionFields ;
#endif

/** \class MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields
 *  \brief Enumeration of MaterialProperty:HeatAndMoistureTransfer:Suction's Idd and Idf extensible fields
 *  to be used in conjunction with ExtensibleIndex and ExtensibleGroup.
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer ExtensibleIndex.field indices. (The enumeration value names
 *  are more likely to be valid across EnergyPlus and OpenStudio releases, and will break
 *  if they become invalid.)See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields, )
#else
class MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields: public ::EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields> {
 public: 
  enum domain 
  {
MoistureContent, LiquidTransportCoefficient,   };
  MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields()
   : EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields>(MoistureContent) {} 
  MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields(const std::string &t_name) 
   : EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields>(t_name) {} 
  MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields(int t_value) 
   : EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields>(t_value) {} 
  static std::string enumName() 
  { return "MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields>::integer_value()); }
   private:
    friend class EnumBase<MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields::MoistureContent, "MoistureContent", "Moisture Content"},
{ MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields::LiquidTransportCoefficient, "LiquidTransportCoefficient", "Liquid Transport Coefficient"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<MaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields> OptionalMaterialProperty_HeatAndMoistureTransfer_SuctionExtensibleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_MATERIALPROPERTY_HEATANDMOISTURETRANSFER_SUCTION_FIELDENUMS_HXX
