/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_COIL_HEATING_ELECTRIC_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_COIL_HEATING_ELECTRIC_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_Coil_Heating_ElectricFields
 *  \brief Enumeration of OS:Coil:Heating:Electric's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_Coil_Heating_ElectricFields, )
#else
class OS_Coil_Heating_ElectricFields: public ::EnumBase<OS_Coil_Heating_ElectricFields> {
 public: 
  enum domain 
  {
Handle, Name, AvailabilityScheduleName, Efficiency, NominalCapacity, AirInletNodeName, AirOutletNodeName, TemperatureSetpointNodeName,   };
  OS_Coil_Heating_ElectricFields()
   : EnumBase<OS_Coil_Heating_ElectricFields>(Handle) {} 
  OS_Coil_Heating_ElectricFields(const std::string &t_name) 
   : EnumBase<OS_Coil_Heating_ElectricFields>(t_name) {} 
  OS_Coil_Heating_ElectricFields(int t_value) 
   : EnumBase<OS_Coil_Heating_ElectricFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_Coil_Heating_ElectricFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_Coil_Heating_ElectricFields>::integer_value()); }
   private:
    friend class EnumBase<OS_Coil_Heating_ElectricFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_Coil_Heating_ElectricFields::Handle, "Handle", "Handle"},
{ OS_Coil_Heating_ElectricFields::Name, "Name", "Name"},
{ OS_Coil_Heating_ElectricFields::AvailabilityScheduleName, "AvailabilityScheduleName", "Availability Schedule Name"},
{ OS_Coil_Heating_ElectricFields::Efficiency, "Efficiency", "Efficiency"},
{ OS_Coil_Heating_ElectricFields::NominalCapacity, "NominalCapacity", "Nominal Capacity"},
{ OS_Coil_Heating_ElectricFields::AirInletNodeName, "AirInletNodeName", "Air Inlet Node Name"},
{ OS_Coil_Heating_ElectricFields::AirOutletNodeName, "AirOutletNodeName", "Air Outlet Node Name"},
{ OS_Coil_Heating_ElectricFields::TemperatureSetpointNodeName, "TemperatureSetpointNodeName", "Temperature Setpoint Node Name"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_Coil_Heating_ElectricFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_Coil_Heating_ElectricFields> OptionalOS_Coil_Heating_ElectricFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_COIL_HEATING_ELECTRIC_FIELDENUMS_HXX
