/***********************************************************************************************************************
*  OpenStudio(R), Copyright (c) Alliance for Energy Innovation, LLC.
*  See also https://openstudio.net/license
***********************************************************************************************************************/

#ifndef UTILITIES_IDD_OS_SOLARCOLLECTORPERFORMANCE_PHOTOVOLTAICTHERMAL_SIMPLE_FIELDENUMS_HXX
#define UTILITIES_IDD_OS_SOLARCOLLECTORPERFORMANCE_PHOTOVOLTAICTHERMAL_SIMPLE_FIELDENUMS_HXX

#include <utilities/UtilitiesAPI.hpp>
#include <utilities/core/Enum.hpp>

namespace openstudio {
/** \class OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields
 *  \brief Enumeration of OS:SolarCollectorPerformance:PhotovoltaicThermal:Simple's Idd and Idf non-extensible fields. 
 *  \details This enumeration provides readable, and semi-robust tags to use instead
 *  of bare unsigned integer field indices. (The enumeration value names are more likely
 *  to be valid across EnergyPlus and OpenStudio releases, and will break if they become
 *  invalid.) See the OPENSTUDIO_ENUM documentation in utilities/core/Enum.hpp. The actual macro
 *  call is:
 *
 *  \code
 *  \endcode */
#ifdef SWIG 
  OPENSTUDIO_ENUM(OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields, )
#else
class OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields: public ::EnumBase<OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields> {
 public: 
  enum domain 
  {
Handle, Name, FractionofSurfaceAreawithActiveThermalCollector, ThermalConversionEfficiencyInputModeType, ValueforThermalConversionEfficiencyifFixed, ThermalConversionEfficiencyScheduleName, FrontSurfaceEmittance,   };
  OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields()
   : EnumBase<OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields>(Handle) {} 
  OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields(const std::string &t_name) 
   : EnumBase<OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields>(t_name) {} 
  OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields(int t_value) 
   : EnumBase<OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields>(t_value) {} 
  static std::string enumName() 
  { return "OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields"; }
  domain value() const { return static_cast<domain>(EnumBase<OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields>::integer_value()); }
   private:
    friend class EnumBase<OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields>;
    typedef std::pair<std::string, int> PT;
    typedef std::vector<PT> VecType;
    static VecType buildStringVec(bool isd)
    {
      struct evalue
      {
        int value; const char *name; const char *description;
      };
      const evalue a[] =
      {
{ OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields::Handle, "Handle", "Handle"},
{ OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields::Name, "Name", "Name"},
{ OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields::FractionofSurfaceAreawithActiveThermalCollector, "FractionofSurfaceAreawithActiveThermalCollector", "Fraction of Surface Area with Active Thermal Collector"},
{ OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields::ThermalConversionEfficiencyInputModeType, "ThermalConversionEfficiencyInputModeType", "Thermal Conversion Efficiency Input Mode Type"},
{ OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields::ValueforThermalConversionEfficiencyifFixed, "ValueforThermalConversionEfficiencyifFixed", "Value for Thermal Conversion Efficiency if Fixed"},
{ OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields::ThermalConversionEfficiencyScheduleName, "ThermalConversionEfficiencyScheduleName", "Thermal Conversion Efficiency Schedule Name"},
{ OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields::FrontSurfaceEmittance, "FrontSurfaceEmittance", "Front Surface Emittance"},
        { 0,0,0 }
      };
      VecType v;
      int i = 0;
      while (!(a[i].value == 0 && a[i].name == 0 && a[i].description == 0))
      {
        if (isd)
        {
          std::string description = a[i].description; 
          if (!description.empty())
          {
            v.push_back(PT(description, a[i].value));
          }
        } else {
          v.push_back(PT(a[i].name, a[i].value));
        }
        ++i;
      }
      return v;
    }
  
  };
  inline std::ostream &operator<<(std::ostream &os, const OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields &e)
  {
    return os << e.valueName() << "(" << e.value() << ")";
  }
  typedef boost::optional<OS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields> OptionalOS_SolarCollectorPerformance_PhotovoltaicThermal_SimpleFields ;
#endif

} // openstudio

#endif // UTILITIES_IDD_OS_SOLARCOLLECTORPERFORMANCE_PHOTOVOLTAICTHERMAL_SIMPLE_FIELDENUMS_HXX
